<?php

declare(strict_types=1);

namespace Zeedhi\Framework\ORM;

use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\DBAL\Platforms\DB2Platform;
use Doctrine\DBAL\Platforms\OraclePlatform;
use Doctrine\DBAL\Platforms\PostgreSQLPlatform;

use function strtolower;
use function strtoupper;


trait SQLResultCasing
{
    private function getSQLResultCasing(AbstractPlatform $platform, string $column): string
    {
        if ($platform instanceof DB2Platform || $platform instanceof OraclePlatform) {
            return strtoupper($column);
        }

        if ($platform instanceof PostgreSQLPlatform) {
            $connectionParams = \Zeedhi\Framework\DependencyInjection\InstanceManager::getInstance()->getParameter('connection_params');
            $useUpperCase = ($connectionParams['driverOptions'][8] ?? null) === 1;

            return $useUpperCase ? strtoupper($column) : strtolower($column);
        }

        return $column;
    }
}
