<?php
namespace Zeedhi\Framework\DBAL\Driver\OCI8;


use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Driver\OCI8\Exception\ConnectionFailed;
use Doctrine\DBAL\Driver\OCI8\Exception\InvalidConfiguration;
use Doctrine\DBAL\Driver\OCI8\OCI8Exception;
use Doctrine\DBAL\Driver\DriverException;
use Zeedhi\Framework\DependencyInjection\InstanceManager;
use Zeedhi\Framework\Util\Functions;
use Doctrine\DBAL\Driver\AbstractOracleDriver;

class Driver extends AbstractOracleDriver
{
    public static function convertExceptionParentStatic(): \Doctrine\DBAL\Driver\API\ExceptionConverter{
       $self = new Driver();
       return $self->convertExceptionParent();
    }
    public function convertExceptionParent(): \Doctrine\DBAL\Driver\API\ExceptionConverter{
        return parent::getExceptionConverter();
    }

    public function getExceptionConverter(): \Doctrine\DBAL\Driver\API\ExceptionConverter
    {
        return  new ExceptionConverter();
    }

    public function connect(
        array $params
    )
    {
        $username = $params['user'] ?? '';
        $password = $params['password'] ?? '';
        $charset = $params['charset'] ?? '';
        $sessionMode = $params['sessionMode'] ?? OCI_NO_AUTO_COMMIT;

        $isWallet = false;
        if(isset($params['host']) && empty($params['host'])) {
            $connectionString = $params['dbname'];
            $isWallet = true;
        } else {
            $connectionString = $this->getEasyConnectString($params);
        }

        $persistent = !empty($params['persistent']);
        $exclusive = !empty($params['driverOptions']['exclusive']);

        if ($persistent && $exclusive) {
            throw InvalidConfiguration::forPersistentAndExclusive();
        }

        if ($persistent) {
            $connection = @oci_pconnect($username, $password, $connectionString, $charset, $sessionMode);
        } elseif ($exclusive) {
            $connection = @oci_new_connect($username, $password, $connectionString, $charset, $sessionMode);
        } else if ($isWallet) {
            putenv('NLS_LANG=AMERICAN_AMERICA.WE8MSWIN1252');
            $connection = @oci_connect($username, $password, $connectionString, null, OCI_CRED_EXT);
        } else {
            $connection = @oci_connect($username, $password, $connectionString, $charset, $sessionMode);
        }

        if ($connection === false) {
            throw ConnectionFailed::new();
        }

        return new \Zeedhi\Framework\DBAL\Driver\OCI8\OCI8Connection($connection);
    }

    public function getName() {
        return 'zeedhi_oci8';
    }
}