<?php
namespace Zeedhi\Framework\DataSource\Operator;

use Zeedhi\Framework\DataSource\Configuration;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\Util\QuerySelector;

class Like extends DefaultOperator{

    public function __construct(Configuration $dataSourceConfig) {
        parent::__construct(FilterCriteria::LIKE, $dataSourceConfig);
    }

    protected function buildExpression($columnName, $parameterName) {
        if(in_array($columnName, $this->dataSourceConfig->getColumnsForResultSet())) {
            if ($this->dataSourceConfig->validateDriverName(QuerySelector::DRIVER_AS_LIKE_FORCE)) {
                $columnName = $columnName . '::varchar';
            }
            return $this->getExpressionBuilder()->like($columnName, $parameterName);
        }
    }
}