<?php
namespace Zeedhi\Framework\DataSource\Operator;

use Zeedhi\Framework\DataSource\Configuration;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\Util\QuerySelector;

class LikeI extends DefaultOperator{

    public function __construct(Configuration $dataSourceConfig) {
        parent::__construct(FilterCriteria::LIKE_I, $dataSourceConfig);
    }

    public function buildExpression($columnName, $parameterName) {
        if(in_array($columnName, $this->dataSourceConfig->getColumnsForResultSet(true))) {
            $expressionBuilder = $this->getExpressionBuilder();
            $columnName = $expressionBuilder->lower($columnName);
            $parameterName = $expressionBuilder->lower($parameterName);
            
            if ($this->dataSourceConfig->validateDriverName(QuerySelector::DRIVER_AS_LIKE_FORCE)) {
                $columnName = $columnName . '::varchar';
            }
            return $this->getExpressionBuilder()->like($columnName, $parameterName);
        }
    }
}