<?php
namespace Zeedhi\Framework\ORM\Platform;


class PostgreSQLPlatform extends \Doctrine\DBAL\Platforms\PostgreSQL100Platform
{
    /**
     * {@inheritDoc}
     */
    public function getDateFormatString() {
        return 'd/m/Y H:i:s';
    }

    /**
     * {@inheritDoc}
     */
    public function getDateTimeFormatString() {
        return 'd/m/Y H:i:s';
    }

    public function getSQLResultCasing($column)
    {
        $connectionParams = \Zeedhi\Framework\DependencyInjection\InstanceManager::getInstance()->getParameter('connection_params');
        $useUpperCase = ($connectionParams['driverOptions'][8] ?? null) === 1;

        return $useUpperCase ? strtoupper($column) : strtolower($column);
    }
}
