<?php
namespace Zeedhi\Framework\DTO\Next;

use Zeedhi\Framework\DataSource\DataSet;

/**
 * Class Next
 *
 * Contains the data to be returned in the response
 *
 * @package Zeedhi\Framework\DTO\Response
 */
class Response {
    /** @var string */
    public const URI = "uri";
    /** @var DataSet */
    protected $dataSet;
    /** @var array */
    protected $row;
    /** @var string */
    protected $dataSourceName;
    /** @var array */
    protected $primaryKeyColumns;

    /**
     * Constructor.
     *
     * @param string $dataSourceName               Optional. The dataSourceName.
     * @param array  $primaryKeyColumns Optional. The primaryKey columns.
     */
    public function __construct($dataSourceName = "", $primaryKeyColumns = []) {
        $this->dataSet = null;
        $this->row = null;
        $this->dataSourceName = $dataSourceName;
        $this->primaryKeyColumns = $primaryKeyColumns;
    }

    /**
     * Returns the dataSet.
     *
     * @return DataSet|null
     */
    public function getDataSet() {
        return $this->dataSet;
    }

    /**
     * Returns the row.
     *
     * @return array|null
     */
    public function getRow() {
        return $this->row;
    }

    /**
     * Sets the dataSet.
     *
     * @param DataSet
     */
    public function setDataSet(DataSet $dataSet) {
        $this->dataSet = $dataSet;
    }

    /**
     * Sets the row.
     *
     * @param array
     */
    public function setRow(array $row) {
        $this->row = $row;
    }

    /**
     * Sets the dataSourceName.
     *
     * @param string
     */
    public function setDataSourceName(string $dataSourceName) {
        $this->dataSourceName = $dataSourceName;
    }

    /**
     * Gets the dataSourceName.
     *
     * @return string
     */
    public function getDataSourceName() {
        return $this->dataSourceName;
    }

    /**
     * Sets the primary key columns.
     *
     * @param array
     */
    public function setPrimaryKeyColumns(array $primaryKeyColumns) {
        $this->primaryKeyColumns = $primaryKeyColumns;
    }

    /**
     * Gets the primary key columns.
     *
     * @return array
     */
    public function getPrimaryKeyColumns() : array {
        return $this->primaryKeyColumns;
    }

    /**
     * Returns a link the view of the specific row.
     *
     * @param string $host  The host within scheme and port.
     * @param string $dataSourceName   Optional. The dataSourceName.
     * @param string $value Optional. The value to be append to the link.
     *
     * @return string
     */
    public function getLink(string $host, $dataSourceName = "", $value = "") : string {
        return $host . $dataSourceName . $value;
    }
}