<?php

namespace Zeedhi\Framework\Util;

use Zeedhi\Framework\DependencyInjection\InstanceManager;

class Functions {

    public static function arrayKeyExists($needle, $array) {
        $keys = array_keys((array)$array);
        return in_array($needle, $keys, true);
    }

    public static function handleOraErrors($message) {
        if(strpos($message, 'An exception occurred while executing') !== false) {
            $messageParts = explode('An exception occurred while executing', $message);
            if(count($messageParts) > 0) {
                $message = trim($messageParts[1]);
            }
        }
        if(strpos($message, 'ORA-') !== false) {
            $messageParts = explode('ORA-', $message);
            if(count($messageParts) > 0) {
                $message = 'ORA-' . trim($messageParts[1]);
                $initMessage = trim($messageParts[0]);
                if(strpos($initMessage, 'with params') !== false) {
                    $messageParams = explode('with params', $initMessage);
                    if(count($messageParams) > 0) {
                        $message .= ' | PARAMS: ' . rtrim($messageParams[1], ':');
                        $message .= ' | COMMAND: ' . trim($messageParams[0]);
                    }
                } else {
                    $message .= $initMessage;
                }
            }
        }
        return $message;
    }

    public static function getHidePHPErrors() {
        try {
            return InstanceManager::getInstance()->getParameter('hidePHPErrors') == 'true';
        } catch (\Exception $e) {
            return true;
        }
    }

    public static function getHideOracleErrors() {
        try {
            return InstanceManager::getInstance()->getParameter('hideOracleErrors') == 'true';
        } catch (\Exception $e) {
            return true;
        }
    }
}
