<?php
namespace Zeedhi\Framework\Service;

use Zeedhi\Framework\DataSource\Manager\Doctrine\NameProvider;

class Next {

    /** @var NameProvider */
    private $nameProvider;

    public function __construct(NameProvider $nameProvider) {
        $this->nameProvider = $nameProvider;
    }

    /**
     * Gets the dataSourceName from the requested uri.
     *
     * @param array $arrayUri The array of requested uri.
     * @param string $uri The last dataSourceName.
     *
     * @return string
     */
    public function getDataSourceName(array $arrayUri, string $dataSourceName = '') : string {
        $uri = array_shift($arrayUri);
        $dataSourceName = $uri ? $uri : $dataSourceName;
        if($arrayUri) {
            $dataSource = $this->nameProvider->getDataSourceByName($dataSourceName);
            $primaryKeys = $dataSource->getPrimaryKeyColumns();
            foreach($primaryKeys as $column) {
                array_shift($arrayUri);
            }
            $dataSourceName = $this->getDataSourceName($arrayUri, $dataSourceName);
        }
        return $dataSourceName;
    }

    /**
    * Receive the requested URI and returns an array with
    * your elements (without query).
    *
    * @param string $uri Requested uri.
    *
    * @return array
    */
    public static function buildArrayUri(string $uri) : array {
        $uri = explode('?', $uri);
        $uri = is_array($uri) ? $uri[0] : $uri;
        $arrayUri = explode('/', $uri);
        if(isset($arrayUri[1])) {
            array_shift($arrayUri);
            if(!end($arrayUri)) {
                array_pop($arrayUri);
            }
        }
        return $arrayUri;
    }
}