# Zh Preferences Backend API
This library receives Zeedhi Preferences and saves them in your database.

## 1. Requirements
**Zh Preferences** requires:
* **PHP**: version 5.6.x
* **[zeedhi/framework][ZEEDHI]**: version 1.4.0 or higher
* **All preferences tables in your database**: see [topic 3][DATABASE_TOPIC]

## 2. Instalation
2.1. Add composer dependency: [zeedhi/preferences][CDN_LINK]

2.2. Implements service named 'environment' with **getOrganizationId** and **getUserId** functions. If your project environment hasn't this functions, override 'preferencesOrganizationEvent' and 'preferencesCrud' services and inject a class with this functions.

2.3. Include preferences services in your instance manager. Ex.:
```PHP
// Preferences Configuration
$instanceManager->loadFromFile(__DIR__.'/../vendor/zeedhi/preferences/services.xml');
```

2.4. Implements 'preferencesFolderLocationProvider' service refer [FolderLocationProvider][FOLDER_LOCATION_PROVIDER].
Suggestion: use [ContainerNameMappingProvider][CONTAINER_MAPPING_PROVIDER]. Ex.:
```html
<service id="preferencesFolderLocationProvider" class="Zeedhi\Preferences\API\Service\FolderProvider\ContainerNameMappingProvider">
    <argument>../../jsonPreferencesFolder</argument>
</service>
```

2.5. Add preferences routes in your router parser using:
> file path: `/../vendor/zeedhi/preferences/routes.json`
```PHP
$routes[] = __DIR__ . "/../vendor/zeedhi/preferences/routes.json";
    ...
$instanceManager->registerService('routeParser', new \Zeedhi\Framework\Routing\Parsers\JSONFormat($routes));
```
> or XML Parameter Name: `preferences_route_file`
```xml
<service id="routeParser" class="%routerParser.class%">
    <argument type="collection">
        <argument>%route_file_name%</argument>
            ...
        <argument>%preferences_route_file%</argument>
    </argument>
</service>
```



## 3. Database
Examples and database versioning in [migrations folder][MIGRATIONS_FOLDER].
### 3.1. Tables

#### 3.1.1. ZH_PREFERENCE_FILTER
| Name | Type | Nullable | Default | Key |
| --- | :---: | :---: | :---: | :---: |
| ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | PK |
| USER_ID | [VARCHAR2][ORACLE_VARCHAR2] | No | - | PK and FK(Users Table) |
| ORGANIZATION_ID | [NUMBER(10,0)][ORACLE_NUMBER_10] | No | - | FK(Organizations Table)|
| LABEL | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| WIDGET_ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| FILTER_ROW | [CLOB][ORACLE_CLOB]| No | - | - |
| LAST_MODIFIED_DATE | [DATE][ORACLE_DATE]| No | [SYSDATE][ORACLE_SYSDATE] | - |

* Add unique: LABEL, WIDGET_ID, USER_ID


#### 3.1.2. ZH_PREFERENCE_LAYOUT
| Name | Type | Nullable | Default | Key |
| --- | :---: | :---: | :---: | :---: |
| ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | PK |
| USER_ID | [VARCHAR2][ORACLE_VARCHAR2] | No | - | PK |
| ORGANIZATION_ID | [NUMBER(10,0)][ORACLE_NUMBER_10] | No | - | - |
| LABEL | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| PDF_REPORT_ORIENTATION | [VARCHAR2][ORACLE_VARCHAR2] (20 BYTE) | No | - | - |
| WIDGET_ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| LAYOUT_CHANGES | [CLOB][ORACLE_CLOB]| No | - | - |
| LAST_MODIFIED_DATE | [DATE][ORACLE_DATE]| No | [SYSDATE][ORACLE_SYSDATE] | - |

* Add check: PDF_REPORT_ORIENTATION in('PORTRAIT', 'LANDSCAPE')
* Add unique: LABEL, WIDGET_ID, USER_ID

#### 3.1.3. ZH_PREFERENCE_VIEW
| Name | Type | Nullable | Default | Key |
| --- | :---: | :---: | :---: | :---: |
| ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | PK |
| USER_ID | [VARCHAR2][ORACLE_VARCHAR2] | No | - | PK |
| ORGANIZATION_ID | [NUMBER(10,0)][ORACLE_NUMBER_10] | No | - | - |
| LABEL | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| WIDGET_ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| FILTER_ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | FK(Filters Table) |
| LAYOUT_ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | FK(Layouts Table) |
| LAST_MODIFIED_DATE | [DATE][ORACLE_DATE]| No | [SYSDATE][ORACLE_SYSDATE] | - |

* Add unique: USER_ID, WIDGET_ID, FILTER_ID, LAYOUT_ID
* Add unique: LABEL, WIDGET_ID, USER_ID

#### 3.1.4. ZH_USER_WIDGET
| Name | Type | Nullable | Default | Key |
| --- | :---: | :---: | :---: | :---: |
| ID | [NUMBER(10,0)][ORACLE_NUMBER_10] | No | - | PK |
| USER_ID | [VARCHAR2][ORACLE_VARCHAR2] | No | - | - |
| ORGANIZATION_ID | [NUMBER(10,0)][ORACLE_NUMBER_10] | No | - | - |
| WIDGET_ID | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | No | - | - |
| DEFAULT_FILTER | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | Yes | - | FK(Filters Table) |
| DEFAULT_LAYOUT | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | Yes | - | FK(Layouts Table) |
| DEFAULT_VIEW | [VARCHAR2][ORACLE_VARCHAR2] (255 BYTE) | Yes | - | FK(Views Table) |
| LAST_MODIFIED_DATE | [DATE][ORACLE_DATE]| No | [SYSDATE][ORACLE_SYSDATE] | - |

* Add unique: USER_ID, WIDGET_ID
* Add sequence: SEQ_USER_WIDGET

## 4. To dev
 * Run tests in [Zeedhi Preferences Samples][ZEEDHI_PREFERENCES_SAMPLES];
 * Run unit tests.

## 5. Samples
You can see how to configure and use in [Zeedhi Preferences Samples][ZEEDHI_PREFERENCES_SAMPLES].

## 6. All related projects
 - [Zeedhi Preferences Samples][ZEEDHI_PREFERENCES_SAMPLES]
 - [Zh Preferences Backend API][ZH_PREFERENCES_BACKEND_API]
 - [Zh Preferences Frontend API][ZH_PREFERENCES_FRONTEND_API]
 - [Zh Filter Preferences][ZH_FILTER_PREFERENCES]
 - [Zh Layout Preferences][ZH_LAYOUT_PREFERENCES]
 - [Zh View Preferences][ZH_VIEW_PREFERENCES]


## 7. Advanced Usage
For advanced usage you can visit the **[API documentation](http://docs.zeedhi.com/)**.


[ZEEDHI]: http://code.zeedhi.com/zeedhi/framework
[CDN_LINK]: http://cdn.zeedhi.com/#zeedhi/preferences
[DATABASE_TOPIC]: http://code.zeedhi.com/zeedhi/zh-preference-backend/tree/master#3-database
[MIGRATIONS_FOLDER]: http://code.zeedhi.com/zeedhi/zh-preference-backend/tree/master/migrations
[FOLDER_LOCATION_PROVIDER]: http://code.zeedhi.com/zeedhi/zh-preference-backend/blob/master/src/Service/FolderLocationProvider.php
[CONTAINER_MAPPING_PROVIDER]: http://code.zeedhi.com/zeedhi/zh-preference-backend/blob/master/src/Service/FolderProvider/ContainerNameMappingProvider.php
[ZEEDHI_PREFERENCES_SAMPLES]: http://code.zeedhi.com/zeedhi/zzeedhi/zeedhi-preferences-samples/tree/master
[ZH_PREFERENCES_BACKEND_API]: http://code.zeedhi.com/zeedhi/zh-preference-backend/tree/master
[ZH_PREFERENCES_FRONTEND_API]: http://code.zeedhi.com/zeedhi-components/zh-customizations-service/tree/master
[ZH_FILTER_PREFERENCES]: http://code.zeedhi.com/zeedhi-components/zh-filter-preferences/tree/master
[ZH_LAYOUT_PREFERENCES]: http://code.zeedhi.com/zeedhi-components/zh-layout-preferences/tree/master
[ZH_VIEW_PREFERENCES]: http://code.zeedhi.com/zeedhi-components/zh-customization-preferences/tree/master
[ORACLE_NUMBER_10]: https://docs.oracle.com/cd/B28359_01/server.111/b28318/datatype.htm#CNCPT1832
[ORACLE_DATE]: https://docs.oracle.com/cd/B28359_01/server.111/b28318/datatype.htm#CNCPT413
[ORACLE_CLOB]: https://docs.oracle.com/cd/B28359_01/server.111/b28318/datatype.htm#CNCPT1843
[ORACLE_VARCHAR2]: https://docs.oracle.com/cd/B28359_01/server.111/b28318/datatype.htm#CNCPT1822
[ORACLE_SYSDATE]: https://docs.oracle.com/cd/B19306_01/server.102/b14200/functions172.htm