<?php
namespace Zeedhi\Preferences\API\Model\Events\Audit;

use Zeedhi\Preferences\API\Model\Events\Audit\AuditAble;

use DateTime;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;

class Subscriber implements EventSubscriber {

    protected function updateLastModifiedDate(LifecycleEventArgs $args) {
        $entity = $args->getEntity();
        if ($entity instanceof AuditAble) {
            $date = new DateTime();
            $entity->setLastModifiedDate($date);
        }
    }

    public function prePersist(LifecycleEventArgs $args) {
        $this->updateLastModifiedDate($args);
    }

    public function preUpdate(LifecycleEventArgs $args) {
        $this->updateLastModifiedDate($args);
    }

    /**
     * Returns an array of events this subscriber wants to listen to.
     *
     * @return array
     */
    public function getSubscribedEvents() {
        return array(
            Events::prePersist,
            Events::preUpdate
        );
    }
}