<?php
namespace Zeedhi\Preferences\API\Model\Events\Organization;

use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;

class Subscriber implements EventSubscriber {

    protected $environment;

    public function __construct($environment) {
        $this->environment = $environment;
    }

    public function prePersist(LifecycleEventArgs $args) {
        $entity = $args->getEntity();
        if ($entity instanceof OrganizationAble) {
            $organization = $this->environment->getOrganizationId();
            $entity->setOrganization($organization);
        }
    }

    public function preUpdate(LifecycleEventArgs $args) {
        $entity = $args->getEntity();
        if ($entity instanceof OrganizationAble) {
            $organizationID = $this->environment->getOrganizationID();

            $changeSet = $args->getEntityChangeSet();

            if (isset($changeSet['organization'])) {
                $original = $changeSet['organization'][0];
                $originalID = $original->getId();
            } else {
                $originalID = $entity->getOrganization();
            }

            if ($organizationID != $originalID) {
                throw Exception::invalidOperation();
            }
        }
    }

    public function preRemove(LifecycleEventArgs $args) {
        $entity = $args->getEntity();
        if ($entity instanceof OrganizationAble) {
            $organization = $this->environment->getOrganizationId();
            $entityOrganization = $entity->getOrganization();

            if ($organization != $entityOrganization) {
                throw Exception::invalidOperation();
            }
        }
    }

    /**
     * Returns an array of events this subscriber wants to listen to.
     *
     * @return array
     */
    public function getSubscribedEvents() {
        return array(
            Events::prePersist,
            Events::preUpdate,
            Events::preRemove
        );
    }
}