<?php
namespace Zeedhi\Preferences\API\Service\FolderProvider;

use Zeedhi\Preferences\API\Service\FolderLocationException;
use Zeedhi\Preferences\API\Service\FolderLocationProvider;

class ContainerNameMappingProvider implements FolderLocationProvider {

    /** @var string */
    private $preferencesRootFolder;

    /**
     * @param string $preferencesRootFolder
     */
    public function __construct($preferencesRootFolder) {
        $this->preferencesRootFolder = $preferencesRootFolder;
    }

    /**
     * Retrieve the folder where are stored the preferences files for given widget.
     *
     * @param string $containerName The NAME of container that has the desired widget.
     * @param string $widgetId The ID of widget that we look for preferences.
     *
     * @return string The path to the folder.
     *
     * @throws FolderLocationException When construct folder does not exists.
     */
    public function getFolderLocation($containerName, $widgetId) {
        $widgetPreferencesFolder = $this->preferencesRootFolder . DIRECTORY_SEPARATOR . $containerName . DIRECTORY_SEPARATOR . $widgetId;
        if(!realpath($widgetPreferencesFolder)) {
            throw FolderLocationException::folderNotFound($containerName, $widgetId);
        }
        return $widgetPreferencesFolder;
    }
}