<?php
namespace Zeedhi\Preferences\API\Service\Repositories;

use Zeedhi\Preferences\API\Service\FolderLocationProvider;

class Layout extends AbstractRepository {

    const LAYOUT_EXTENSION = 'layout';
    const COLUNM_DATA_NAME = 'LAYOUT_CHANGES';

    /**
     * @param FolderLocationProvider $folderProvider
     */
    public function __construct(FolderLocationProvider $folderProvider) {
        parent::__construct($folderProvider, self::LAYOUT_EXTENSION);
    }

    /**
     * @param array $preference
     *
     * @return array $preference
     */
    protected function parseJSONColunms($preference){
        $preference[self::COLUNM_DATA_NAME] = json_encode($preference[self::COLUNM_DATA_NAME]);
        return $preference;
    }
}