<?php
namespace tests\Zeedhi\Preferences\API\Controller\Compositions;

use Zeedhi\Framework\Controller\Crud;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DTO\Request\DataSet;
use Zeedhi\Framework\DTO\Request\Filter;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Preferences\API\Controller\Compositions\CompositeController;
use Zeedhi\Preferences\API\Controller\Repositories\AbstractController;

class CompositeControllerTest extends \PHPUnit_Framework_TestCase {

    /** @var AbstractController|\PHPUnit_Framework_MockObject_MockObject */
    private $repositoryController;
    /** @var Crud|\PHPUnit_Framework_MockObject_MockObject */
    private $crudController;
    /** @var CompositeController */
    private $controller;

    protected function setUp() {
        $this->crudController = $this->getMockBuilder(Crud::class)
            ->disableOriginalConstructor()
            ->setMethods(array('find', 'save', 'delete'))
            ->getMock();

        $this->repositoryController = $this->getMockBuilder(AbstractController::class)
            ->disableOriginalConstructor()
            ->setMethods(array('find'))
            ->getMock();

        $this->controller = new CompositeController($this->crudController, $this->repositoryController, 'view');
    }

    public function testSave() {
        $request = new DataSet(new \Zeedhi\Framework\DataSource\DataSet('view', array()), 'POST','/view/save', 'userId');
        $response = new Response();

        $this->crudController->expects($this->once())
            ->method('save')
            ->with($request, $this->callback(function($response) {
                return $response instanceof Response;
            }));

        $this->controller->save($request, $response);
    }

    public function testDelete() {
        $request = new DataSet(new \Zeedhi\Framework\DataSource\DataSet('view', array()), 'POST','/view/delete', 'userId');
        $response = new Response();

        $this->crudController->expects($this->once())
            ->method('delete')
            ->with($request, $this->callback(function($response) {
                return $response instanceof Response;
            }));

        $this->controller->delete($request, $response);
    }

    public function testFind() {
        $request = new Filter(new FilterCriteria('view'), 'POST','/view/delete', 'userId');
        $response = new Response();

        $crudView = array(
            "LABEL" => "View 1",
            "WIDGET_ID" => "widgetId",
            "FILTER_ID" => "Filter1",
            "LAYOUT_ID" => "Layout1",
            "LAST_MODIFIED_DATE" => "2017-11-30 08:00:00"
        );

        $this->crudController->expects($this->once())
            ->method('find')
            ->with($request, $this->callback(function($response) use($crudView) {
                if ($response instanceof Response) {
                    $response->addDataSet(new \Zeedhi\Framework\DataSource\DataSet('view', array($crudView)));
                }

                return $response instanceof Response;
            }));


        $repositoryView = array(
            "LABEL" => "View 2",
            "WIDGET_ID" => "widgetId",
            "FILTER_ID" => "Filter2",
            "LAYOUT_ID" => "Layout2",
            "LAST_MODIFIED_DATE" => "2017-11-30 08:00:00"
        );

        $this->repositoryController->expects($this->once())
            ->method('find')
            ->with($request, $this->callback(function($response) use($repositoryView) {
                if ($response instanceof Response) {
                    $response->addDataSet(new \Zeedhi\Framework\DataSource\DataSet('view', array($repositoryView)));
                }

                return $response instanceof Response;
            }));

        $this->controller->find($request, $response);

        /** @var \Zeedhi\Framework\DataSource\DataSet $dataSet */
        $dataSet = current($response->getDataSets());
        $this->assertEquals(array($crudView, $repositoryView), $dataSet->getRows());
    }
}
