<?php
namespace tests\Zeedhi\Preferences\API\Controller\Repositories;

use \Zeedhi\Preferences\API\Controller\Repositories\View;
use \Zeedhi\Preferences\API\Controller\Repositories\AbstractController;
use \Zeedhi\Preferences\API\Service\Repositories\View as ViewService;

class ViewTest extends \PHPUnit_Framework_TestCase {
    /** @var View */
    private $controller;
    /** @var AbstractRepository|\PHPUnit_Framework_MockObject_MockObject */
    private $repository;

    protected function setUp() {
        $this->repository = $this->getMockBuilder(ViewService::class)
            ->disableOriginalConstructor()
            ->setMethods(array('findPreferencesFor'))
            ->getMock();
        $this->controller = new View($this->repository);
    }

    public function testInstaceOf(){
        $this->assertInstanceOf(AbstractController::class, $this->controller);
    }

    public function testFindBy() {
        $filterCriteria = new \Zeedhi\Framework\DataSource\FilterCriteria('view');
        $filterCriteria->addCondition('WIDGET_ID', 'widgetId');
        $request = new \Zeedhi\Framework\DTO\Request\Filter($filterCriteria, 'POST', '/view', 'userId');
        $request->setParameter('origin', array('containerName' => 'containerName', 'widgetName' => 'widgetName'));
        $response = new \Zeedhi\Framework\DTO\Response();

        $preferences = array(
            array(
                "LABEL" => "View 1",
                "WIDGET_ID" => "widgetId",
                "FILTER_ID" => "Filter1",
                "LAYOUT_ID" => "Layout1",
                "LAST_MODIFIED_DATE" => "2017-11-30 08:00:00"
            )
        );
        $this->repository->expects($this->once())
            ->method('findPreferencesFor')
            ->with('containerName', 'widgetId')
            ->willReturn($preferences);

        $this->controller->find($request, $response);

        $expectedDataSets = array(new \Zeedhi\Framework\DataSource\DataSet('view', $preferences));
        $this->assertEquals($expectedDataSets, $response->getDataSets());
    }
}
