<?php
namespace Zeedhi\Preferences\API\Service\Repositories;

use \Zeedhi\Preferences\API\Service\FolderLocationProvider;
use \Zeedhi\Preferences\API\Service\FolderLocationException;

class FilterTest extends \PHPUnit_Framework_TestCase {

    /** @var Filter */
    private $filterRepository;
    /** @var FolderLocationProvider|\PHPUnit_Framework_MockObject_MockObject */
    private $folderLocationProviderMock;

    protected function setUp() {
        $this->folderLocationProviderMock = $this->getMockBuilder(FolderLocationProvider::class)
            ->getMock();

        $this->filterRepository = new Filter(
            $this->folderLocationProviderMock
        );
    }

    public function testFindFilterPreferences() {
        $expectedPreferences = array(
            ['ID'=> 'b_filter', 'LABEL'=> 'Filter2', 'WIDGET_ID'=> 'widgetId', 'FILTER_ROW'=> '{"COLUMN_NAME":"OtherValue"}', 'LAST_MODIFIED_DATE'=> '2017-11-30 08:00:00', 'USER_ID'=> 1],
            ['ID'=> 'a_filter', 'LABEL'=> 'Filter1', 'WIDGET_ID'=> 'widgetId', 'FILTER_ROW'=> '{"COLUMN_NAME":"Value"}', 'LAST_MODIFIED_DATE'=> '2017-11-30 08:00:00', 'USER_ID'=> 1]
        );

        $this->folderLocationProviderMock->expects($this->once())
            ->method('getFolderLocation')
            ->with('containerName', 'widgetId')
            ->willReturn(realpath(__DIR__.'/../../../mocks/preferencesRootFolder/containerName/widgetId'));

        $preferences = $this->filterRepository->findPreferencesFor('containerName', 'widgetId');
        $this->assertEquals($expectedPreferences, $preferences);
    }

    public function testFindOnEmptyFolder() {
        $this->folderLocationProviderMock->expects($this->once())
            ->method('getFolderLocation')
            ->with('containerName', 'emptyWidget')
            ->willReturn(realpath(__DIR__.'/../../../mocks/preferencesRootFolder/containerName/emptyWidget'));

        $preferences = $this->filterRepository->findPreferencesFor('containerName', 'emptyWidget');
        $this->assertEquals(array(), $preferences);
    }

    public function testFindOnInvalidWidgetFolder() {
        $expectedException = FolderLocationException::folderNotFound('containerName', 'invalidWidget');
        $this->folderLocationProviderMock->expects($this->once())
            ->method('getFolderLocation')
            ->with('containerName', 'invalidWidget')
            ->willThrowException($expectedException);
        $preferences = $this->filterRepository->findPreferencesFor('containerName', 'invalidWidget');
        $this->assertEquals(array(), $preferences);
    }
}
