CREATE TABLE ZH_PREFERENCE_FILTER
(
  ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, USER_ID VARCHAR2(12 BYTE)
, ORGANIZATION_ID NUMBER(10,0) NOT NULL ENABLE
, LABEL VARCHAR2(255 BYTE) NOT NULL ENABLE
, WIDGET_ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, FILTER_ROW CLOB NOT NULL ENABLE
, LAST_MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL ENABLE
,  CONSTRAINT ZH_PREFERENCE_FILTER_PK PRIMARY KEY (ID, USER_ID) ENABLE
,  CONSTRAINT ZH_PREFERENCE_FILTER_NAME_UK UNIQUE (LABEL, WIDGET_ID, USER_ID) ENABLE
)
/

CREATE TABLE ZH_PREFERENCE_LAYOUT
(
  ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, USER_ID VARCHAR2(12 BYTE) NOT NULL ENABLE
, ORGANIZATION_ID NUMBER(10,0) NOT NULL ENABLE
, LABEL VARCHAR2(255 BYTE) NOT NULL ENABLE
, PDF_REPORT_ORIENTATION VARCHAR2(20 BYTE) NOT NULL ENABLE
, WIDGET_ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, LAYOUT_CHANGES CLOB NOT NULL ENABLE
, LAST_MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL ENABLE
,  CONSTRAINT ZH_PREFERENCE_LAYOUT_PK PRIMARY KEY (ID, USER_ID) ENABLE
,  CONSTRAINT ZH_PREFERENCE_LAYOUT_CHK CHECK (PDF_REPORT_ORIENTATION IN('PORTRAIT', 'LANDSCAPE')) ENABLE
,  CONSTRAINT ZH_PREFERENCE_LAYOUT_NAME_UK UNIQUE (LABEL, WIDGET_ID, USER_ID) ENABLE
)
/
CREATE TABLE ZH_PREFERENCE_VIEW
(
  ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, USER_ID VARCHAR2(12 BYTE) NOT NULL ENABLE
, ORGANIZATION_ID NUMBER(10,0) NOT NULL ENABLE
, LABEL VARCHAR2(255 BYTE) NOT NULL ENABLE
, WIDGET_ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, FILTER_ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, LAYOUT_ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, LAST_MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL ENABLE
,  CONSTRAINT ZH_PREFERENCE_VIEW_PK PRIMARY KEY (ID, USER_ID) ENABLE
,  CONSTRAINT ZH_PREFERENCE_VIEW_OPTS_UK UNIQUE (USER_ID, WIDGET_ID, FILTER_ID, LAYOUT_ID) ENABLE
,  CONSTRAINT ZH_PREFERENCE_VIEW_NAME_UK UNIQUE (LABEL, WIDGET_ID, USER_ID) ENABLE
,  CONSTRAINT ZH_PREFERENCE_VIEW_FILTER_FK FOREIGN KEY (FILTER_ID, USER_ID)
    REFERENCES ZH_PREFERENCE_FILTER (ID, USER_ID) ENABLE
,  CONSTRAINT ZH_PREFERENCE_VIEW_LAYOUT_FK FOREIGN KEY (LAYOUT_ID, USER_ID)
    REFERENCES ZH_PREFERENCE_LAYOUT (ID, USER_ID) ENABLE
)
/
CREATE TABLE ZH_USER_WIDGET
(
  ID NUMBER(10,0) NOT NULL ENABLE
, USER_ID VARCHAR2(12 BYTE) NOT NULL ENABLE
, ORGANIZATION_ID NUMBER(10,0) NOT NULL ENABLE
, WIDGET_ID VARCHAR2(255 BYTE) NOT NULL ENABLE
, DEFAULT_FILTER VARCHAR2(255 BYTE)
, DEFAULT_LAYOUT VARCHAR2(255 BYTE)
, DEFAULT_VIEW VARCHAR2(255 BYTE)
, LAST_MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL ENABLE
,  CONSTRAINT ZH_USER_WIDGET_PK PRIMARY KEY (ID) ENABLE
,  CONSTRAINT ZH_USER_WIDGET_UK UNIQUE (WIDGET_ID, USER_ID) ENABLE
,  CONSTRAINT ZH_USER_WIDGET_FILTER_FK FOREIGN KEY (DEFAULT_FILTER, USER_ID)
    REFERENCES ZH_PREFERENCE_FILTER (ID, USER_ID) ENABLE
,  CONSTRAINT ZH_USER_WIDGET_LAYOUT_FK FOREIGN KEY (DEFAULT_LAYOUT, USER_ID)
    REFERENCES ZH_PREFERENCE_LAYOUT (ID, USER_ID) ENABLE
,  CONSTRAINT ZH_USER_WIDGET_VIEW_FK FOREIGN KEY (DEFAULT_VIEW, USER_ID)
    REFERENCES ZH_PREFERENCE_VIEW (ID, USER_ID) ENABLE
)
/
CREATE SEQUENCE SEQ_USER_WIDGET
/