<?php
namespace Zeedhi\Preferences\API\Controller\Compositions;

use Zeedhi\Framework\DTO;
use Zeedhi\Framework\Controller\Crud;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Preferences\API\Controller\Repositories\AbstractController;

class CompositeController extends Crud {

    /** @var Crud  */
    private $crudController;
    /** @var AbstractController */
    private $repositoryController;

    /**
     * @param Crud $crudController
     * @param AbstractController $repositoryController
     * @param string $dataSourceName
     */
    function __construct(Crud $crudController, AbstractController $repositoryController, $dataSourceName) {
        $this->crudController = $crudController;
        $this->repositoryController = $repositoryController;
        $this->dataSourceName = $dataSourceName;
    }

    /**
     * @param DTO\Request\DataSet $request
     * @param DTO\Response $response
     */
    public function save(DTO\Request\DataSet $request, DTO\Response $response) {
        $this->crudController->save($request, $response);
    }

    /**
     * @param DTO\Request\DataSet $request
     * @param DTO\Response $response
     */
    public function delete(DTO\Request\DataSet $request, DTO\Response $response) {
        $this->crudController->delete($request, $response);
    }

    /**
     * @param Crud|AbstractController $controller
     * @param DTO\Request $request
     * @return array
     */
    private function findByController($controller, DTO\Request $request) {
        $fakeResponse = new DTO\Response();
        $controller->find($request, $fakeResponse);
        /** @var DataSet $dataSet */
        $dataSet = current($fakeResponse->getDataSets());
        return $dataSet->getRows();
    }

    /**
     * @param DTO\Request\Filter $request
     * @param DTO\Response $response
     */
    public function find(DTO\Request\Filter $request, DTO\Response $response) {
        $crudRows = $this->findByController($this->crudController, $request);
        $repositoryRows = $this->findByController($this->repositoryController, $request);
        $rows = array_merge($crudRows, $repositoryRows);
        $response->addDataSet(new DataSet($this->dataSourceName, $rows));
    }
}