<?php
namespace Zeedhi\Preferences\API\Controller\Crud;

use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Preferences\API\Controller\Compositions\Filter as FilterComposition;
use Zeedhi\Preferences\API\Controller\Compositions\Layout as LayoutComposition;

class DefaultPreferences extends PreferencesCrud {

    const DATA_SOURCE_NAME = 'user_widget';
    const DATA_SOURCE_FIND_NAME = 'user_widget_find';
    protected $dataSourceName = self::DATA_SOURCE_NAME;

    public function find(DTO\Request\Filter $request, DTO\Response $response){
        $this->parameterBag->set('ORGANIZATION_ID', $this->environment->getOrganizationId());
        $this->parameterBag->set('USER_ID', $this->environment->getUserId());
        $filterData = $request->getFilterCriteria();
        $filterData->setDataSourceName(self::DATA_SOURCE_FIND_NAME);
        $dataSet = $this->dataSourceManager->findBy($filterData);
        $rows = $dataSet->getRows();
        if(count($rows)){
            $this->addDataSets($response, $rows[0]);
        } else {
            $response->addDataSet(new DataSet(self::DATA_SOURCE_NAME, array()));
        }
    }

    private function addDataSets($response, $row){
        $this->addDefaultDataSet($response, $row);
        if($row['DEFAULT_FILTER'])
            $this->addFilterDataSet($response, $row);

        if($row['DEFAULT_LAYOUT'])
            $this->addLayoutDataSet($response, $row);

        if($row['DEFAULT_VIEW'])
            $this->addViewDataSet($response, $row);

    }

    private function addDefaultDataSet($response, $row){
        $defaultRow = array(
            "ID" => $row['ID'],
            "USER_ID" => $row['USER_ID'],
            "WIDGET_ID" => $row['WIDGET_ID'],
            "DEFAULT_FILTER" => $row['DEFAULT_FILTER'],
            "DEFAULT_LAYOUT" => $row['DEFAULT_LAYOUT'],
            "DEFAULT_VIEW" => $row['DEFAULT_VIEW'],
            "LAST_MODIFIED_DATE" => $row['LAST_MODIFIED_DATE']
        );
        $response->addDataSet(new DataSet(self::DATA_SOURCE_NAME, array($defaultRow)));
    }

    private function addFilterDataSet($response, $row){
        $filterRow = array(
            "ID" => $row['DEFAULT_FILTER'],
            "USER_ID" => $row['USER_ID'],
            "WIDGET_ID" => $row['WIDGET_ID'],
            "LABEL_TO_PREFERENCE" => $row['FILTER_LABEL'],
            "FILTER_ROW" => $row['FILTER_ROW']
        );
        $response->addDataSet(new DataSet('defaultFilter', array($filterRow)));
    }

    private function addLayoutDataSet($response, $row){
        $layoutRow = array(
            "ID" => $row['DEFAULT_LAYOUT'],
            "USER_ID" => $row['USER_ID'],
            "WIDGET_ID" => $row['WIDGET_ID'],
            "LABEL_TO_PREFERENCE" => $row['LAYOUT_LABEL'],
            "LAYOUT_CHANGES" => $row['LAYOUT_CHANGES'],
            "PDF_REPORT_ORIENTATION" => $row['PDF_REPORT_ORIENTATION']
        );
        $response->addDataSet(new DataSet('defaultLayout', array($layoutRow)));
    }

    private function addViewDataSet($response, $row){
        $viewRow = array(
            "ID" => $row['DEFAULT_VIEW'],
            "USER_ID" => $row['USER_ID'],
            "WIDGET_ID" => $row['WIDGET_ID'],
            "LABEL_TO_PREFERENCE" => $row['VIEW_LABEL'],
            "FILTER_ID" => $row['VIEW_FILTER_ID'],
            "LAYOUT_ID" => $row['VIEW_LAYOUT_ID'],
            "FILTER_OBJ" => $this->findPreferenceById(FilterComposition::DATA_SOURCE_NAME, $row['VIEW_FILTER_ID']),
            "LAYOUT_OBJ" => $this->findPreferenceById(LayoutComposition::DATA_SOURCE_NAME, $row['VIEW_LAYOUT_ID'])
        );
        $response->addDataSet(new DataSet('defaultView', array($viewRow)));
    }

    private function findPreferenceById($datasourceName, $id){
        $filter = array(
            'columnName' => 'ID',
            'operator' => '=',
            'value' => $id
        );
        $filterCriteria = new FilterCriteria($datasourceName, array($filter), 1, 1);
        $rows = $this->dataSourceManager->findBy($filterCriteria)->getRows();
        return count($rows) ? $rows[0] : null;
    }

}