<?php
namespace Zeedhi\Preferences\API\Controller\Crud;

use Zeedhi\Framework\DTO;
use Zeedhi\Preferences\API\Controller\Compositions\Filter as FilterComposition;
use Zeedhi\Preferences\API\Controller\Compositions\Layout as LayoutComposition;
use Zeedhi\Preferences\API\Controller\Compositions\View as ViewComposition;

class Preferences {
    /** @var FilterComposition */
    protected $filterController;
    /** @var LayoutComposition */
    protected $layoutController;
    /** @var LayoutComposition */
    protected $viewController;

    /**
     * @param FilterComposition $filterController
     * @param LayoutComposition $layoutController
     * @param ViewComposition $viewController
     */
    public function __construct(
        FilterComposition $filterController,
        LayoutComposition $layoutController,
        ViewComposition $viewController
    ) {
        $this->filterController = $filterController;
        $this->layoutController = $layoutController;
        $this->viewController = $viewController;
    }

    /**
     * @param DTO\Request\Filter $request
     * @param DTO\Response $response
     */
    public function find(DTO\Request\Filter $request, DTO\Response $response) {
        $this->filterController->find($request, $response);
        $this->layoutController->find($request, $response);
        $this->viewController->find($request, $response);
    }
}