<?php
namespace Zeedhi\Preferences\API\Controller\Crud;

use Zeedhi\Preferences\API\Controller\Compositions\View as ViewComposition;

use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DTO\Response\Notification;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DataSource\Manager\Exception as ManagerException;

class View extends PreferencesCrud {

    protected $dataSourceName = ViewComposition::DATA_SOURCE_NAME;

    protected function getErrorCode($error) {
        $oraErrorCode = $this->getORAErrorCode($error);

        switch ($oraErrorCode) {
            case 'ORA-00001': return 'save_error_duplicated_view';
            default:          return $error;
        }
    }

    public function save(DTO\Request\DataSet $request, DTO\Response $response){
        try {
            $this->validateDataSetUserId($request);

            $dataSet = $request->getDataSet();
            $dataSet->setDataSourceName($this->dataSourceName);
            $persistedRows = $this->dataSourceManager->persist($dataSet);
            $response->addDataSet(new DataSet($this->dataSourceName, $persistedRows));
            $nrPersistedRows = count($persistedRows);
            $response->addNotification(new Notification("{$nrPersistedRows} row(s) persisted with success", Notification::TYPE_SUCCESS));
        } catch (ManagerException $e) {
            $errorCode = $this->getErrorCode($e->getMessage());

            $response->setError(new DTO\Response\Error(
                $errorCode ?: $e->getMessage(),
                $e->getCode(),
                $e->getTraceAsString())
            );
        } catch (\Exception $e) {
            $response->setError(new DTO\Response\Error(
                $e->getMessage(),
                $e->getCode(),
                $e->getTraceAsString())
            );
        }
    }

}