<?php
namespace Zeedhi\Preferences\API\Controller\Repositories;

use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DTO\Request\Filter;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Preferences\API\Service\Repositories\AbstractRepository;

abstract class AbstractController {

    /** @var string */
    private $preferenceDataSetName;
    /** @var AbstractRepository */
    private $repository;

    /**
     * @param AbstractRepository $repository
     * @param string $preferenceDataSetName
     */
    function __construct(AbstractRepository $repository, $preferenceDataSetName) {
        $this->preferenceDataSetName = $preferenceDataSetName;
        $this->repository = $repository;
    }

    /**
     * @param Filter $request
     * @param Response $response
     */
    public function find(Filter $request, Response $response) {
        $containerName = $request->getParameter('origin')['containerName'];
        foreach($request->getFilterCriteria()->getConditions() as $condition) {
            if($condition['columnName'] === 'WIDGET_ID') {
                $widgetId = $condition['value'];
            }
        }
        $preferences = $this->repository->findPreferencesFor($containerName, $widgetId);
        $response->addDataSet(new DataSet($this->preferenceDataSetName, $preferences));
    }
}