<?php
namespace Zeedhi\Preferences\API\Factory;

use Doctrine\ORM\ORMException;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Configuration;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DriverManager;
use Doctrine\Common\EventManager;
use Zeedhi\Framework\ORM\ConnectionFactory;

class EntityManagerFactory extends EntityManager {

    /**
     * Factory method to create EntityManager instances without the custom platform.
     *
     * @param array         $conn         An array with the connection parameters
     * @param Configuration $config       The Configuration instance to use.
     * @param EventManager  $eventManager The EventManager instance to use.
     *
     * @return EntityManager The created EntityManager.
     *
     * @throws \InvalidArgumentException
     * @throws ORMException
     */
    public static function create($conn, Configuration $config, EventManager $eventManager = null){
        if(!$config->getMetadataDriverImpl()){
            throw ORMException::missingMappingDriverImpl();
        }

        switch(true){
            case ($conn instanceof Connection):
                $conn = $conn->getParams();
            case (is_array($conn)):
                $conn = self::createConnection($conn, $config, $eventManager);
                break;
            default:
                throw new \InvalidArgumentException("The argument should be an array or instanceof DBAL\Connection.");
        }

        return new EntityManager($conn, $config, $conn->getEventManager());
    }

    protected static function createConnection($conn, $config, EventManager $eventManager = null){
        $eventManager = $eventManager ?: new EventManager();
        if(!isset($conn['isEncrypted']) || $conn['isEncrypted']){
            $conn = ConnectionFactory::factoryWithEncryptedPassword($conn, $config, $eventManager);
        } else {
            $conn = DriverManager::getConnection($conn, $config, $eventManager);
        }

        return $conn;
    }
}