<?php
namespace Zeedhi\Preferences\API\Service\Repositories;

use Zeedhi\Preferences\API\Service\FolderLocationException;
use Zeedhi\Preferences\API\Service\FolderLocationProvider;

abstract class AbstractRepository {

    const PREFERENCE_TYPE = "F";

    /** @var string */
    private $preferenceExtension;
    /** @var FolderLocationProvider */
    private $folderProvider;

    /**
     * @param FolderLocationProvider $folderProvider
     * @param string $preferenceExtension
     */
    public function __construct(FolderLocationProvider $folderProvider, $preferenceExtension) {
        $this->folderProvider = $folderProvider;
        $this->preferenceExtension = $preferenceExtension;
    }

    /**
     * @param array $preference
     *
     * @return array $preference
     */
    protected function parseJSONColunms($preference){
        return $preference;
    }

    /**
     * @param string path
     *
     * @return array
     */
     private function getPreferencesInDirectory($path){
        $preferences = array();
        $directoryIterator = new \RecursiveDirectoryIterator($path);
        /** @var \SplFileInfo $file */
        while($directoryIterator->valid() && $file = $directoryIterator->current()) {
            if($file->isFile() && $file->getExtension() === $this->preferenceExtension) {
                $preference = json_decode(file_get_contents($file->getPathname()), true);
                $preferenceId = str_replace('.' . $this->preferenceExtension, '', $file->getFilename());
                $preference['ID'] = $preferenceId;
                $preference['USER_ID'] = 1;
                $preference['TYPE'] = self::PREFERENCE_TYPE;
                $preferences[] = $this->parseJSONColunms($preference);
            }

            $directoryIterator->next();
        }
        return $preferences;
    }

    /**
     * @param string $containerName
     * @param string $widgetId
     *
     * @return array
     */
    public function findPreferencesFor($containerName, $widgetId) {
        try {
            $folderPath = $this->folderProvider->getFolderLocation($containerName, $widgetId);
            $preferences = $this->getPreferencesInDirectory($folderPath);
        } catch(FolderLocationException $e){
            $preferences = array();
        }
        return $preferences;
    }
}