<?php
namespace tests\Zeedhi\Preferences\API\Controller\Crud;

use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DataSource\FilterCriteria;

use Zeedhi\Preferences\API\Controller\Crud\Preferences;
use Zeedhi\Preferences\API\Controller\Compositions\Filter as FilterComposition;
use Zeedhi\Preferences\API\Controller\Compositions\Layout as LayoutComposition;
use Zeedhi\Preferences\API\Controller\Compositions\View as ViewComposition;

class PreferencesTest extends \PHPUnit_Framework_TestCase {
    /** @var FilterComposition */
    protected $filterController;
    /** @var LayoutComposition */
    protected $layoutController;
    /** @var LayoutComposition */
    protected $viewController;
    /** @var Preference */
    protected $preferencesController;

    protected function setUp(){
        $this->filterController = $this->getMockBuilder(FilterComposition::class)
            ->disableOriginalConstructor()
            ->setMethods(array('find'))
            ->getMock();

        $this->layoutController = $this->getMockBuilder(LayoutComposition::class)
            ->disableOriginalConstructor()
            ->setMethods(array('find'))
            ->getMock();

        $this->viewController = $this->getMockBuilder(ViewComposition::class)
            ->disableOriginalConstructor()
            ->setMethods(array('find'))
            ->getMock();

        $this->preferencesController = new Preferences($this->filterController, $this->layoutController, $this->viewController);
    }

    public function testFind(){
        $request = new DTO\Request\Filter(new FilterCriteria(''), 'POST', '/preference', 'userId');
        $response = new DTO\Response();

        $this->filterController->expects($this->once())
            ->method('find')
            ->with($request, $response);

        $this->layoutController->expects($this->once())
            ->method('find')
            ->with($request, $response);

        $this->viewController->expects($this->once())
            ->method('find')
            ->with($request, $response);

        $this->preferencesController->find($request, $response);
    }

}