<?php
namespace tests\Zeedhi\Preferences\API\Service\FolderProvider;

use \Zeedhi\Preferences\API\Service\FolderProvider\ContainerNameMappingProvider;
use \Zeedhi\Preferences\API\Service\FolderLocationException;

class ContainerNameMappingProviderTest extends \PHPUnit_Framework_TestCase {

    /** @var ContainerNameMappingProvider */
    private $folderProvider;
    /** @var string */
    private $rootFolder;

    public function setUp() {
        $this->rootFolder = realpath(__DIR__ . '/../../../mocks/preferencesRootFolder/');

        $this->folderProvider = new ContainerNameMappingProvider($this->rootFolder);
    }

    public function testGetFolderLocation() {
        $folder = $this->folderProvider->getFolderLocation('containerName', 'widgetId');
        $this->assertEquals($this->rootFolder . DIRECTORY_SEPARATOR . 'containerName' . DIRECTORY_SEPARATOR . 'widgetId', $folder);
    }

    public function testNonExistentFolder() {
        $this->expectException(FolderLocationException::class);
        $this->expectExceptionMessage("Preferences for widget (wrongContainerName->widgetId) not found!");
        $this->folderProvider->getFolderLocation('wrongContainerName', 'widgetId');
    }
}