<?php
namespace Zeedhi\Report;

use \Zeedhi\Report\Report;
use \Zeedhi\Report\LogoConfig;
use \Zeedhi\Report\Reader\IReader;
use \Zeedhi\Report\ReportStrategy;

class ReportBuilder {

    private $reportMetadata;
    private $reportData;
    private $targetFile;
    private $templatePath;
    private $cachePath;
    private $templateName = 'report-angular.php.twig';
    private $logoConfig;
    private $isWebService;

    private $reportStrategy;

    public function __construct(array $reportMetadata, array $reportData, LogoConfig $logoConfig, $templatePath, $cachePath, $targetFile, $assetsPath, $isWebService = false) {
        $this->reportMetadata = $reportMetadata;
        $this->reportData = $reportData;
        $this->logoConfig = $logoConfig;
        $this->targetFile = $targetFile;
        $this->templatePath = $templatePath;
        $this->cachePath = $cachePath;
        $this->assetsPath = $assetsPath;
        $this->isWebService = $isWebService;
    }

    private function buildHtmlReport(){
        $this->reportStrategy = new ReportStrategy\HTML(
            $this->reportMetadata,
            $this->reportData,
            $this->logoConfig,
            $this->templatePath,
            $this->cachePath,
            $this->targetFile,
            $this->assetsPath,
            $this->templateName
        );
        
        $this->reportStrategy->start();
    }

    private function buildPDFReport(){
        $this->reportStrategy = new ReportStrategy\PDF($this->reportMetadata, $this->isWebService);

        if(!empty($this->reportData)){
            $this->reportStrategy->writeRows($this->reportData, true);
            $this->reportStrategy->finish($this->targetFile, true);
        }
    }

    public function buildReport($type = "html") {
        switch($type){
            case "pdf":
                $this->buildPDFReport();
                break;
            case "html":
                $this->buildHtmlReport();
                break;
        }
    }

    public function writeRows($rows){
        $this->reportStrategy->writeRows($rows);
    }

    public function finish(){
        $this->reportStrategy->finish($this->targetFile);
        return $this->targetFile;
    }

    public function getTemplatePath() {
        return $this->templatePath;
    }

    public function getCachePath() {
        return $this->cachePath;
    }

    public function getTemplateName() {
        return $this->templateName;
    }

    public function getTargetFile() {
        return $this->targetFile;
    }

    public function getLogoConfig() {
        return $this->logoConfig;
    }

    public function setLogoConfig($logoConfig) {
        $this->logoConfig = $logoConfig;
    }

}