<?php

namespace Zeedhi\ZhuAcl\Controller;

use Zeedhi\ZhuAcl\Controller\ZhuCrud;
use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DataSource\Manager;
use Zeedhi\Framework\DataSource\ParameterBag;
use Zeedhi\ZhuAcl\Util\Environment as EnvironmentAcl;

class AccessControlLogin extends ZhuCrud {

    const RULE_ALLOW = 'A';
    const RULE_READONLY = 'R';
    const RULE_INVISIBLE = 'I';

    protected $dataSourceName = 'zhu_access_control_rule_login';
    protected $defaltRuleDataSourceName = 'zhu_access_control_default_rule';
    protected $parameterBagColumns = array('GROUP_ID', 'PROJECT_ID');
    protected $rowsIndexedByUniqueId = array();
    protected $environment;

    public function __construct(Manager $dataSourceManager, ParameterBag $parameterBag, EnvironmentAcl $environment) {
        $this->environment = $environment;
        parent::__construct($dataSourceManager, $parameterBag);
    }

    private function getDefaultRuleDataSet(){
        $defaultRuleRow = array(
            'defaultRule' => $this->environment->getDefaultRule()
        );
        return new DataSet($this->defaltRuleDataSourceName, $defaultRuleRow);
    }

    public function find(DTO\Request\Filter $request, DTO\Response $response) {
        $filterCriteria = $request->getFilterCriteria();
        $filterCriteria->setDataSourceName($this->dataSourceName);
        $newFilterCriteria = $this->populateParameterBag($filterCriteria);
        $dataSet = $this->dataSourceManager->findBy($newFilterCriteria);
        $response->addDataSet($dataSet);
        $response->addDataSet($this->getDefaultRuleDataSet());
    }

    protected function populateParameterBag(FilterCriteria $filterCriteria) {
        $conditions = array();

        foreach ($filterCriteria->getConditions() as $condition) {
            $columnName = $condition['columnName'];
            if ($columnName === 'GROUP_ID') {
                $condition['value'] = implode(',', $condition['value']);
            }

            if (in_array($columnName, $this->parameterBagColumns)) {
                $this->parameterBag->set($columnName, $condition['value']);
            } else {
                $conditions[] = $condition;
            }
        }
        if(!empty($this->environment->getOrganizationId())) {
            $this->parameterBag->set('ORGANIZATION_ID', $this->environment->getOrganizationId());
        }

        $newFilterCriteria = new FilterCriteria(
            $filterCriteria->getDataSourceName(),
            $conditions
        );

        return $newFilterCriteria;
    }

}