<?php

namespace Zeedhi\ZhuAcl\Factory;

use Doctrine\Common\EventManager;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DriverManager;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\ORMException;
use Doctrine\DBAL\LockMode;
use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Proxy\ProxyFactory;
use Doctrine\ORM\Query\FilterCollection;
use Doctrine\Common\Util\ClassUtils;
use Zeedhi\Framework\ORM\ConnectionFactory;

class EntityManagerFactory extends EntityManager {
    /**
     * Factory method to create EntityManager instances without the custom platform.
     *
     * @param array         $conn         An array with the connection parameters
     * @param Configuration $config       The Configuration instance to use.
     * @param EventManager  $eventManager The EventManager instance to use.
     *
     * @return EntityManager The created EntityManager.
     *
     * @throws \InvalidArgumentException
     * @throws ORMException
     */
    public static function create($conn, Configuration $config, EventManager $eventManager = null) {
        if ( ! $config->getMetadataDriverImpl()) {
            throw ORMException::missingMappingDriverImpl();
        }

        switch (true) {
            case ($conn instanceof Connection):
                $conn = $conn->getParams();
            case (is_array($conn)):
                $conn = self::createConnection($conn, $config, $eventManager);
                break;
            default:
                throw new \InvalidArgumentException("The argument should be an array: " . $conn);
        }

        return new EntityManager($conn, $config, $conn->getEventManager());
    }

    protected static function createConnection($conn, $config, EventManager $eventManager = null) {
        if (!isset($conn['isEncrypted']) || $conn['isEncrypted']) {
            $conn = ConnectionFactory::factoryWithEncryptedPassword($conn, $config, ($eventManager ?: new EventManager()));
        } else {
            $conn = DriverManager::getConnection($conn, $config, ($eventManager ?: new EventManager()));
        }

        return $conn;
    }
}