CREATE TABLE "ZHU_ACCESS_CONTROL_ELEMENT"
	("ID" NUMBER(10,0) NOT NULL ENABLE,
	"IS_ACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE,
	"NAME" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	"DESCRIPTION" VARCHAR2(2000 BYTE),
	"HELP" VARCHAR2(2000 BYTE),
	"LABEL" VARCHAR2(120 BYTE),
	"UNIQUE_ID" VARCHAR2(2000 BYTE) NOT NULL ENABLE,
	"PROJECT_ID" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	"PARENT_ID" NUMBER(10,0),
	"TYPE" CHAR(1 BYTE) NOT NULL ENABLE,
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE,
	"CREATED_BY" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE,
	"UPDATED_BY" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	 CONSTRAINT "UNIQUE_ELEMENT" UNIQUE ("UNIQUE_ID", "PROJECT_ID")
	)
/
CREATE TABLE "ZHU_ACCESS_CONTROL_RULE"
	("ID" NUMBER(10,0) NOT NULL ENABLE,
	"IS_ACTIVE" CHAR(1 BYTE) DEFAULT 'Y' NOT NULL ENABLE,
	"NAME" VARCHAR2(120 BYTE),
	"DESCRIPTION" VARCHAR2(2000 BYTE),
	"HELP" VARCHAR2(2000 BYTE),
	"ACCESS_CONTROL_ELEMENT_ID" NUMBER(10,0) NOT NULL ENABLE,
	"ORGANIZATION_ID" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	"GROUP_ID" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	"RULE" CHAR(1 BYTE) NOT NULL ENABLE,
	"CREATED" DATE DEFAULT SYSDATE NOT NULL ENABLE,
	"CREATED_BY" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	"UPDATED" DATE DEFAULT SYSDATE NOT NULL ENABLE,
	"UPDATED_BY" VARCHAR2(120 BYTE) NOT NULL ENABLE,
	 CONSTRAINT "UNIQUE_RULE" UNIQUE ("ORGANIZATION_ID", "GROUP_ID", "ACCESS_CONTROL_ELEMENT_ID")
	)
/
CREATE SEQUENCE "SEQ_ACCESS_CONTROL_ELEMENT"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE  NOPARTITION ;
/
CREATE SEQUENCE "SEQ_ACCESS_CONTROL_RULE"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE  NOPARTITION ;
/