<?php

namespace Zeedhi\ZhuAcl\Controller;

use Zeedhi\Framework\Controller\Crud;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DataSource\Manager;
use Zeedhi\Framework\DataSource\ParameterBag;
use Zeedhi\Framework\DTO;

class ZhuCrud extends Crud{

    protected $dataSourceName;
    protected $dataSourceNameToSave  = false;
    /** @var ParameterBag */
    protected $parameterBag;
    /** @var string[] */
    protected $parameterBagColumns = array();

    public function __construct(Manager $dataSourceManager, ParameterBag $parameterBag) {
        $this->parameterBag = $parameterBag;
        parent::__construct($dataSourceManager);
    }

    public function find(DTO\Request\Filter $request, DTO\Response $response) {
        $filterCriteria = $request->getFilterCriteria();
        $filterCriteria->setDataSourceName($this->dataSourceName);
        $newFilterCriteria = $this->populateParameterBag($filterCriteria);
        $dataSet = $this->dataSourceManager->findBy($newFilterCriteria);
        $response->addDataSet($dataSet);
    }

    protected function populateParameterBag(FilterCriteria $filterCriteria) {
        $conditions = array();
        foreach ($filterCriteria->getConditions() as $condition) {
            $columnName = $condition['columnName'];
            if (in_array($columnName, $this->parameterBagColumns)) {
                $this->parameterBag->set($columnName, $condition['value']);
            } else {
                $conditions[] = $condition;
            }
        }
        $newFilterCriteria = new FilterCriteria(
            $filterCriteria->getDataSourceName(),
            $conditions,
            $filterCriteria->getPage(),
            $filterCriteria->getPageSize()
        );
        return $newFilterCriteria;
    }
}