<?php
namespace Zeedhi\ZhuLog\Listeners;

use Zeedhi\Framework\Events\OnException\Listener;
use Zeedhi\Framework\HTTP\Request;
use Zeedhi\ZhuLog\Logger\Logger;

class OnException extends Listener {
    /** @var Logger $logger The logger object. */
    protected $logger;

    /**
     * Constructor...
     *
     * @param Logger $logger The logger object.
     */
    public function __construct(Logger $logger){
        $this->logger = $logger;
    }

    /**
     * {@inheritDoc}
     */
    public function onException(\Exception $e){
        $request = Request::initfromGlobals();
        $type = $request->getRequestType();
        $method = $request->getMethod();
        $uri = OnRequest::cleanupUri($request->getRequestUri());
        $this->logger->logException($e, $uri, $method, $type);
    }
}