<?php
namespace Zeedhi\ZhuLog\Logger\Processor;

class CompositeProcessor extends Processor {

    /** @var Processor */
    protected $firstProcessor;
    /** @var Processor */
    protected $secondProcessor;

    /**
     * Contructor...
     * 
     * @param Processor $firstProcessor
     * @param Processor $secondProcessor
     */
    public function __construct(Processor $firstProcessor, Processor $secondProcessor) {
        $this->firstProcessor = $firstProcessor;
        $this->secondProcessor = $secondProcessor;
    }

    /**
     * {@inheritDoc}
     */
    public function processRequest(array $request, string $route, string $method) : array {
        return $this->secondProcessor->processRequest(
            $this->firstProcessor->processRequest($request, $route, $method),
            $route, $method
        );
    }

    /**
     * {@inheritDoc}
     */
    public function processResponse(array $response) : array {
        return $this->secondProcessor->processResponse(
            $this->firstProcessor->processResponse($response)
        );
    }

    /**
     * {@inheritDoc}
     */
    public function processException(string $message) : array {
        $firstResult = $this->firstProcessor->processException($message);
        $message = reset($firstResult);
        return $this->secondProcessor->processException($message);
    }
}