<?php
namespace Zeedhi\ZhuLog\Logger\Processor;

class DefaultProcessor extends Processor {

    const KEEP_DATA_SET   = 1;
    const COMPACT_DATA_SET = 2;
    const REMOVE_DATA_SET = 4;

    /** @var int */
    protected $responseDataSetPolicy = self::KEEP_DATA_SET;
    /** @var int */
    protected $requestDataSetPolicy  = self::KEEP_DATA_SET;

    /**
     * DefaultProcessor constructor.
     * @param int       $responseDataSetPolicy
     * @param int       $requestDataSetPolicy
     */
    public function __construct($responseDataSetPolicy = self::KEEP_DATA_SET, $requestDataSetPolicy = self::KEEP_DATA_SET) {
        $this->responseDataSetPolicy = $responseDataSetPolicy;
        $this->requestDataSetPolicy = $requestDataSetPolicy;
    }

    /**
     * @param int $responseDataSetPolicy
     */
    public function setResponseDataSetPolicy($responseDataSetPolicy) {
        $this->responseDataSetPolicy = $responseDataSetPolicy;
    }

    /**
     * @param int $requestDataSetPolicy
     */
    public function setRequestDataSetPolicy($requestDataSetPolicy) {
        $this->requestDataSetPolicy = $requestDataSetPolicy;
    }

    /**
     * {@inheritDoc}
     */
    public function processRequest(array $request, string $route, string $method) : array {
        switch ($this->requestDataSetPolicy) {
            case DefaultProcessor::REMOVE_DATA_SET:
                unset($request['dataset']);
                break;
            case DefaultProcessor::COMPACT_DATA_SET:
                $request['dataset'] = count($request['dataset']);
                break;
        }

        return $request;
    }

    /**
     * {@inheritDoc}
     */
    public function processResponse(array $response) : array {
        switch ($this->responseDataSetPolicy) {
            case DefaultProcessor::REMOVE_DATA_SET:
                unset($response['dataset']);
                break;
            case DefaultProcessor::COMPACT_DATA_SET:
                if (isset($response['dataset'])) {
                    foreach($response['dataset'] as $name => $data) {
                        $response['dataset'][$name] = count($data);
                    }
                }

                break;
        }

        return $response;
    }

    /**
     * {@inheritDoc}
     */
    public function processException(string $message) : array {
        return ['message' => $message];
    }
}