<?php
namespace tests\Zeedhi\ZhuLog\Logger\Processor;

use Zeedhi\ZhuLog\Logger\Processor\SkipFilesProcessor;

class SkipFilesProcessorTest extends \PHPUnit_Framework_TestCase {

    protected $processor;

    public function setUp() {
        $routes = [
            '/uploadRoute' => [
                'fileField'    => 'uploadField',
                'customFolder' => 'folder'
            ]
        ];
        $this->processor = new SkipFilesProcessor($routes);
    }

    public function testProcessRequestRow() {
        $request = [
            'row' => [
                'id' => 1,
                'uploadField' => [
                    [
                        'name' => 'file1.png',
                        'b64File' => '__RANDOM_VALUE_FOR_TEST__'
                    ],
                    [
                        'name' => 'file2.png',
                        'b64File' => '__RANDOM_VALUE_FOR_TEST__'
                    ]
                ],
                'foo' => 'bar'
            ]
        ];
        $route   = '/uploadRoute';
        $method  = 'POST';

        $result = $this->processor->processRequest($request, $route, $method);

        $expected = [
            'row' => [
                'id' => 1,
                'uploadField' => [
                    [
                        'name' => 'file1.png',
                    ],
                    [
                        'name' => 'file2.png',
                    ]
                ],
                'foo' => 'bar'
            ]
        ];
        $this->assertEquals($expected, $result);
    }

    public function testProcessRequestDataSet() {
        $request = [
            'dataset' => [
                [
                    'id' => 1,
                    'uploadField' => [
                        [
                            'name' => 'file1.png',
                            'b64File' => '__RANDOM_VALUE_FOR_TEST__'
                        ],
                        [
                            'name' => 'file2.png',
                            'b64File' => '__RANDOM_VALUE_FOR_TEST__'
                        ]
                    ],
                    'foo' => 'bar'
                ],
                [
                    'id' => 2,
                    'uploadField' => [
                        [
                            'name' => 'file1.png',
                            'b64File' => '__RANDOM_VALUE_FOR_TEST__'
                        ],
                        [
                            'name' => 'file2.png',
                            'b64File' => '__RANDOM_VALUE_FOR_TEST__'
                        ]
                    ],
                    'foo' => 'bar'
                ]
            ]
        ];
        $route   = '/uploadRoute';
        $method  = 'POST';

        $result = $this->processor->processRequest($request, $route, $method);

        $expected = [
            'dataset' => [
                [
                    'id' => 1,
                    'uploadField' => [
                        [
                            'name' => 'file1.png',
                        ],
                        [
                            'name' => 'file2.png',
                        ]
                    ],
                    'foo' => 'bar'
                ],
                [
                    'id' => 2,
                    'uploadField' => [
                        [
                            'name' => 'file1.png',
                        ],
                        [
                            'name' => 'file2.png',
                        ]
                    ],
                    'foo' => 'bar'
                ]
            ]
        ];
        $this->assertEquals($expected, $result);
    }

    public function testProcessResponse() {
        $response = [
            'foo' => [
                ['id' => 1, 'file' => 'path_to_file/582f34a61ec42.png'],
                ['id' => 2, 'file' => 'path_to_file/582f34abae575.png']
            ]
        ];
        $result = $this->processor->processResponse($response);

        $this->assertEquals($response, $result);
    }

    public function testRequestWithEmptyFile() {
        $request = [
            'row' => [
                'id' => 1,
                'foo' => 'bar',
                'notUploadField' => 'qux'
            ]
        ];
        $route   = '/uploadRoute';
        $method  = 'POST';

        $result = $this->processor->processRequest($request, $route, $method);

        $this->assertEquals($request, $result);
    }

}